/*
Server Guestbook

About:
This adds a simple guestbook to your server. It's saved in configs as guestbook.txt(can be changed in source)

Commands:
gb_write <comment> - write's to guestbook
say /guestbook - Shows the guestbook

Cvars:
GB_enabled(Def: 1) - 0: Plugin is disabled, 1: Plugin is enabled.

Notes:

    * I wrote this while i was really tired, there is probaly many bugs
    * First time i had to use so many defines
    * Haven't tested... yet
*/

#include <amxmodx> //loading the modules...
#include <amxmisc> //Another one :)

#define Plugin "Server Guestbook" // i'm using this for register_plugin, incase i wanna chage it later..
#define Version "0.7a"
#define Author "Doombringer"

#define FLAG ADMIN_ALL //Users whit this flag is allowed to write(Default: ADMIN_USER) (Removed in version 0.7, revoked in 0.7a)
//#define GUESTBOOK_FILE "guestbook.htm" //the file that's used to save guestbook comments (Removed in version 0.7)

#define TIMESTAMP "%B %Y - %H:%M:%S" //timestamp, change this if you want!

#define BACKGROUND_COLOR "#666666" //the background color
#define TEXT_COLOR "#FFFF00" //the text color

#define MAX_LEN 132

new cvar, waittime, path, guestbook_name, bool:havetowait[32], filepath[MAX_LEN]; //some stuff'z

public plugin_init() //omg, now we're talking :o
{
	register_plugin(Plugin, Version, Author); //Registers the plugin
	
	cvar = register_cvar("GB_enabled","1"); //The toggle cvar
	waittime = register_cvar("GB_waittime","60");
	path = register_cvar("GB_savepath","");
	guestbook_name = register_cvar("GB_filename","guestbook.htm");
	
	new temp[2][MAX_LEN];
	
	get_pcvar_string(path, temp[0], MAX_LEN-1); //get's the path were to save the guestbook file
	get_pcvar_string(guestbook_name, temp[1], MAX_LEN-1); //get's the name of the guestbook file to write in

	register_concmd("gb_write", "guestbook_write", FLAG, " - <comment> Write's to guestbook"); //This defines that we wanna register a command, the first syntax is the one that has to be written in console
	register_clcmd("say /guestbook", "show_guestbook", FLAG); //Make's so you can show's Guestbook, first syntax is the trigger
	
	register_cvar("GB_Version", Version, FCVAR_SERVER|FCVAR_SPONLY); // Make's a cvar that you can (i think) find in search engines like game-monitor.com
	
	//ok, all set. Now to set the right filepath...
	
	new configsdir[38]; //first, make a array to remember the configs dir
	get_configsdir(configsdir, 37); //ok, new configsdir is loaded whit the path to configs, that is in the amxmodx root
	
	if(equal(temp[0], "")) //if gb_path is empty...
	formatex(filepath, MAX_LEN-1, "%s/%s", configsdir, temp[1]); //... use the default path
	else //else ...
	formatex(filepath, MAX_LEN-1, "%s/%s", temp[0], temp[1]); //... use the path in gb_path instead
	
	if(!file_exists(filepath) && cstrike_running()) //if the guestbook file doesn't exists AND cstrike is running...
	{
		new file = fopen(filepath, "at"), tempp[64]; //open the file...	
		
		formatex(tempp, 63,"<body bgcolor=^"%s^" text=^"%s^"><br \>^n", BACKGROUND_COLOR, TEXT_COLOR); //... fill a sting whit HTML ...
		
		fprintf(file, tempp, 63); //... put some HTML in the file ...
		
		fclose(file); //... done! ^^
	}
	
	server_cmd("exec %s/GB_config.cfg", configsdir);
}

//Now is the main function done, rest below here is trigger functions

public can_write_again(id) havetowait[id] = false;

public guestbook_write(id, level, cid) //this one handles the main function, 1) open file 2) get varios info 3) write into file.
{
	if ( (!cmd_access(id, level, cid, 2)) || id < 1 ) //if the flag(defined in GUESTBOOK_FILE(removed in 0.7, uses cvar now)) isn't matching the users flag(s), or the id is lower then 1(server?), break
	return PLUGIN_HANDLED; //Mission Failed :(
	
	else if (get_pcvar_num(cvar) < 1) // is the plugin disabled?
	{
		client_print(id, print_console,"The plugin is disabled"); //yep it is...
		return PLUGIN_HANDLED; //... Damnit! =(
	}
	
	else if (havetowait[id]) //If the user already has written in the guestbook...
	{
		client_print(id, print_console,"You have already written in the guestbook! please wait a little time and try again!!"); //... say he have to wait and ...
		return PLUGIN_HANDLED; //... deny him ^^
	}
     
	new file = fopen(filepath, "at"); //opens the file, "at" is how it will handle it("at" means to write in the end of the file)
     
	new text[331], name[32], time[26]; //make new array's to store text, name and time
	new Arg[65]; //this one stores the comment the user left
     
	read_args(Arg, 64); //new the Arg array is filled whit the comment
     
	get_time(TIMESTAMP, time, 25); //Get's the time, the format is defined in TIMESTAMP
	get_user_name(id, name, 31); //Get's the name of the id, and fills name whit found name
     
	if(cstrike_running()) //if counter-strike is running, use HTML
	formatex(text, 330,"%s %s Wrote<br \>^n%s <br \><br \>^n^n", time, name, Arg); //the whole "main" in this function. It turn's all info into a string and fills text whit it
	else
	formatex(text, 330,"%s %s Wrote^n%s^n^n", time, name, Arg); //the whole "main" in this function. It turn's all info into a string and fills text whit it
	fprintf(file, text, 330); //ok, we're ready to rumble!!
     
	fclose(file); //Now that we are done, we close the file
	client_print(id, print_console, "You just wrote in the guestbook!"); //Print's a little cute message to the user =)
     
	havetowait[id] = true; //turn's the bool gavetowait to true(used so ppl'z dont spam the GB)
	set_task(float(get_pcvar_num(waittime)), "can_write_again", id) //Set's how long time they have to wait
     
	return PLUGIN_HANDLED; // xD WE ARE DONE!! w00t!
}

public show_guestbook(id, level, cid) //this is used to show the guestbook to the id
{
	if(!cmd_access(id, level, cid, 1)) 
	return PLUGIN_HANDLED
	
	if(get_pcvar_num(cvar) < 1) //is the cvar lower then 1?
	{
		client_print(id, print_chat,"The plugin is disabled"); //yep it is...
		return PLUGIN_CONTINUE; //... Damnit! =(
	}

	show_motd(id, filepath, "Guestbook"); //show the guestbook to the user as MOTD
	return PLUGIN_CONTINUE; //done!
} //EOS